public class Tablica {
  private Object tab[];
  Tablica(int size){
    tab = new Object[size];
  }
  public Object get(int index){
    if(index >= tab.length || index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    else{
      return tab[index];
    }
  }
  public void set(int index, Object value){
    if(index < 0){
      throw new ArrayIndexOutOfBoundsException("index = " + index);
    }
    if(index >= tab.length){
      resize(index + 1);
    }
    tab[index] = value;
  }
  protected void resize(int size){
    Object newTab[] = new Object[size];
    for(int i = 0; i < tab.length; i++){
      newTab[i] = tab[i];
    }
    tab = newTab;
  }
  public int size(){
    return tab.length;
  }

  public static void main(String args[]){
    Tablica rectangles = new Tablica(3);
    rectangles.set(0, new Rectangle());
    rectangles.set(1, new Rectangle());
    rectangles.set(2, new Triangle());
    for(int i = 0; i < rectangles.size(); i++){
      ((Rectangle) rectangles.get(i)).diagonal();
    }
  }
}

class Triangle{};
class Rectangle{
  public void diagonal(){}
}
